// SC510Dlg.h : header file
//

#if !defined(AFX_SC510DLG_H__3FBB5998_12C1_4B1F_8B4C_EE83AA56BC74__INCLUDED_)
#define AFX_SC510DLG_H__3FBB5998_12C1_4B1F_8B4C_EE83AA56BC74__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CSC510Dlg dialog

#include "ChannelWindow.h"

#include "SetupDialog.h"

#include "TabCtrlEx.h"

class CSC510Dlg : public CDialog
{
// Construction
public:
	CSC510Dlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSC510Dlg)
	enum { IDD = IDD_SC510_DIALOG };
	CTabCtrl	m_tabDisplayExchange;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSC510Dlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSC510Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnSelChangeTabDisplay(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	// USER INTERFACE FUNCTION 
	//
	BOOL				OnLButtonDown_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point );

	BOOL				OnLButtonUp_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point );

	BOOL				OnApply_SetupDialog();

	BOOL				OnSnapshot_SetupDialog();

	BOOL				OnSync_SetupDialog();

	BOOL				OnFileSourceDestroy_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceCreate_FileManagerWindow( ULONG nChannelNumber, AMESDK_FILE_INFO * pFileInfo );

	BOOL				OnFileSourceRun_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourcePause_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceStop_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceStep_FileManagerWindow( ULONG nChannelNumber, ULONG nSteps );

	BOOL				OnFileSourceGetVideoStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp, BOOL * pIsKeyFrame );

	BOOL				OnFileSourceGetAudioStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp );

	LONGLONG			OnFileSourceGetMediaLength_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits );

	LONGLONG			OnFileSourceGetMediaPosition_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits );

	BOOL				OnFileSourceSetMediaPosition_FileManagerWindow( ULONG nChannelNumber, LONGLONG nPosition, DWORD dwTimeUnits );

	double				OnFileSourceGetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber );

	BOOL				OnFileSourceSetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber, double dRate );

	// DEVICE FUNCTION 
	// 
	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	// USER INTERFACE PROPERTY 
	// 
	CChannelWindow		m_oChannelWindow_LIVE[ 4 ];						// LIVE STREAM DISPLAY WINDOW

	CChannelWindow		m_oChannelWindow_FILE[ 4 ];						// FILE STREAM DISPLAY WINDOW (RECORD PLAYBACK)

	CSetupDialog		m_oSetupDialog;									// PARAMETER SETUP DIALOG

	ULONG				m_nDisplayModeNumber;							// DISPLAY MODE EXCHANGE (0 = LIVE / 1 = RCPB)

	// DEVICE PROPERTY 
	// 
	DEVICE_HANDLE		m_hVideoDev[ 1 ];								// VIDEO STREAM CAPTURE DEVICE

	DEVICE_HANDLE		m_hAudioDev[ 1 ];								// AUDIO STREAM CAPTURE DEVICE
	
	DEVICE_HANDLE		m_hVideoEncoderDev[ 4 ];						// SOFTWARE (MPEG4/H.264) ENCODER DEVICE

	ULONG				m_nVideoFrameWidth[ 4 ];						// DISPLAY: FRAME WIDTH

	ULONG				m_nVideoFrameHeight[ 4 ];						// DISPLAY: FRAME HEIGHT

	ULONG				m_nVideoFrameRate[ 4 ];							// DISPLAY: FRAME RATE

	ULONG				m_nVideoEncoderFrameWidth[ 4 ];					// RECORDING: FRAME WIDTH

	ULONG				m_nVideoEncoderFrameHeight[ 4 ];				// RECORDING: FRAME HEIGHT

	ULONG				m_nVideoEncoderFrameRate[ 4 ];					// RECORDING: FRAME RATE

	ULONG				m_nVideoEncoderFrameNumber[ 4 ];				// RECORDING: FRAME NUMBER

	// FILE PROPERTY 
	// 
	DEVICE_HANDLE		m_hFileRendererDev[ 4 ];						// FILE RENDERER DEVICE

	ULONG				m_nFileRendererRecordState[ 4 ];				// FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	volatile BOOL		m_bFileRendererChangeNotify[ 4 ];				// FILE RENDERER FILE.CHANGING.EVENT NOTIFY (0 = NONE / 1 = CHANGE)

	SYSTEMTIME			m_sFileRendererChangeSystemTime[ 4 ];			// FILE RENDERER FILE.CHANGING.EVENT SYSTEM TIME

	CHAR				m_pFileRendererChangeDevName[ 4 ][ MAX_PATH ];	// FILE RENDERER FILE.CHANGING.EVENT DEVICE NAME
	
	CRITICAL_SECTION	m_hFileRendererChangeCriticalSection[ 4 ];		// FILE RENDERER FILE.CHANGING.EVENT CRITICAL SECTION

	DEVICE_HANDLE		m_hFileSourceDev[ 4 ];							// FILE SOURCE DEVICE

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SC510DLG_H__3FBB5998_12C1_4B1F_8B4C_EE83AA56BC74__INCLUDED_)
